# 🌐 Vercel Browser Deployment Guide

## 📋 Cara Cepat Deploy Lewat Browser (Tanpa Install CLI)

### 🎯 Langkah 1: Buka Vercel Dashboard
1. Kunjungi [vercel.com](https://vercel.com)
2. Login dengan GitHub/Google/GitLab account
3. Dashboard akan terbuka

---

## 🚀 Langkah 2: Import/Connect Repository

### Option A: Import Repository
1. Klik **"Add New..."**
2. Pilih **"Git Repository"**
3. Masukkan repository URL:
   ```
   https://github.com/username/rental-mobil.git
   ```
4. Klik **"Import"**

### Option B: Connect GitHub
1. Klik **"Continue with GitHub"**
2. Authorize Vercel akses ke GitHub
3. Pilih repository `rental-mobil`
4. Klik **"Import"**

---

## 🏗 Langkah 3: Build Configuration

### A. Framework Detection
Vercel akan otomatis mendeteksi:
- ✅ Next.js project
- ✅ Build command: `npm run build`
- ✅ Output directory: `.next`

### B. Build Settings
1. Di project settings, klik **"Build & Development Settings"**
2. Konfigurasi:
   ```
   Build Command: npm run build
   Output Directory: .next
   Node.js Version: 18.x
   Install Command: npm ci
   ```

---

## 🔧 Langkah 4: Environment Variables

### A. Tambah Environment Variables
1. Klik tab **"Environment Variables"**
2. Tambahkan variables berikut:

   ```env
   DATABASE_URL=file:./db/prod.db
   NEXTAUTH_SECRET=your-super-secret-key-min-32-characters
   NEXTAUTH_URL=https://yourdomain.com
   NODE_ENV=production
   ```

### B. Generate NEXTAUTH_SECRET
Kunjungi [https://generate-secret.vercel.app](https://generate-secret.vercel.app) untuk generate secure key.

---

## 🌐 Langkah 5: Custom Domain Setup

### A. Tambah Custom Domain
1. Klik tab **"Domains"**
2. Klik **"Add Domain"**
3. Masukkan domain Anda: `yourdomain.com`
4. Pilih environment: **Production**
5. Klik **"Add"**

### B. Konfigurasi DNS
Di domain provider Anda, tambahkan DNS record:

#### Option 1: CNAME (Recommended)
```
Type: CNAME
Name: @
Value: cname.vercel-dns.com
TTL: 300
```

#### Option 2: A Record
```
Type: A
Name: @
Value: 76.76.19.19 (IP Vercel)
TTL: 300
```

### C. Subdomain (www)
Untuk www.yourdomain.com:
```
Type: CNAME
Name: www
Value: cname.vercel-dns.com
```

---

## 🚀 Langkah 6: Deploy

### A. Deploy Pertama
1. Klik **"Deployments"** tab
2. Klik **"New Deployment"**
3. Pilih branch: `main`
4. Klik **"Deploy"**

### B. Auto-Deploy (Recommended)
1. Di project settings, klik **"Git Integration"**
2. Enable **"Automatic Deployments"**
3. Set branch: `main`
4. Set trigger: **"On push to main"**

---

## 📊 Langkah 7: Monitoring & Verification

### A. Cek Deployment Status
1. Di dashboard, lihat deployment progress
2. Tunggu hingga status: **"Ready"**
3. Klik URL deployment untuk test

### B. Test Website
```bash
# Test dengan curl
curl -I https://yourdomain.com

# Test di browser
# Buka https://yourdomain.com
```

### C. Check SSL Certificate
1. Klik icon gembok di browser
2. Pastikan **"Connection is secure"** dan **"Certificate is valid"**
3. SSL otomatis dari Vercel (Let's Encrypt)

---

## 🔧 Langkah 8: Advanced Configuration

### A. Custom Build Settings
1. Di **"Build & Development Settings"**
2. **Override Build Command** (jika perlu):
   ```
   npm run build:prod
   ```
3. **Post-Build Script** (jika perlu):
   ```
   echo "Build completed"
   ```

### B. Edge Functions Configuration
1. Di **"Functions"** tab
2. **Function Timeout**: 30-60 seconds
3. **Memory**: 512MB - 1GB
4. **Regions**: Pilih terdekat dengan users

---

## 📱 Langkah 9: Post-Deployment Optimization

### A. Performance Settings
1. Di **"Analytics"** tab
2. Enable **"Web Vitals"**
3. Setup **"Speed Insights"**

### B. Security Headers
1. Di **"Settings"** → **"Security"**
2. Enable **"CORS Protection"**
3. Configure **"Rate Limiting"**

### C. Custom Error Pages
1. Di **"Settings"** → **"Error Pages"**
2. Upload custom 404.html
3. Upload custom 500.html

---

## 🔄 Langkah 10: Update & Maintenance

### A. Update Code
```bash
# Push changes ke GitHub
git add .
git commit -m "Update untuk production"
git push origin main

# Vercel akan otomatis redeploy
```

### B. Rollback
1. Di **"Deployments"** tab
2. Cari deployment sebelumnya
3. Klik **"..."** → **"Promote to Production"**
4. Pilih deployment yang ingin di-rollback

### C. Maintenance Mode
1. Di **"Settings"** → **"Maintenance"**
2. Enable **"Maintenance Mode"**
3. Upload custom maintenance page

---

## 🛠️ Langkah 11: Troubleshooting Browser

### A. Common Issues

#### 1. Import Repository Gagal
```bash
# Pastikan repository public
# Check GitHub permissions
# Gunakan personal access token
```

#### 2. Build Error
```bash
# Cek build logs di Vercel dashboard
# Pastikan package.json benar
# Cek Node.js version compatibility
```

#### 3. Environment Variables Not Working
```bash
# Restart deployment
# Clear cache: Clear Cache & Re-deploy
# Check variable names dan values
```

#### 4. Domain Not Pointing
```bash
# Check DNS propagation
nslookup yourdomain.com
dig yourdomain.com CNAME

# Verify di Vercel dashboard
# Contact domain provider support
```

---

## 📋 Quick Reference

### Commands Vercel Dashboard
- **Deploy**: `Deployments` → `New Deployment`
- **Logs**: `Functions` → `Logs`
- **Settings**: `Settings` → `Environment Variables`
- **Domains**: `Domains` → `Add Domain`
- **Analytics**: `Analytics` → `Overview`

### Keyboard Shortcuts
- `Ctrl + S`: Save changes
- `Ctrl + Enter`: Execute command
- `Tab`: Navigate fields

---

## 🎯 Success Checklist

### Pre-Deployment:
- [ ] Repository berhasil di-import
- [ ] Build settings terkonfigurasi
- [ ] Environment variables ditambahkan
- [ ] Custom domain ditambahkan
- [ ] DNS records terkonfigurasi

### Post-Deployment:
- [ ] Deployment status: Ready
- [ ] Website accessible via custom domain
- [ ] HTTPS working (green padlock)
- [ ] All pages return 200 status
- [ ] Forms berfungsi properly
- [ ] No console errors
- [ ] Mobile responsive
- [ ] SSL certificate valid

---

## 📞 Support

### Vercel Resources:
- [Documentation](https://vercel.com/docs)
- [Support Center](https://vercel.com/support)
- [Status Page](https://vercel-status.com/)
- [Community](https://vercel.com/discord)

### Emergency Contacts:
- **Live Chat**: Di Vercel dashboard
- **Email**: support@vercel.com
- **Twitter**: @vercel

---

## 🎉 Deployment Complete!

Website rental mobil Anda siap go-live dengan Vercel! 

**Next Steps:**
1. ✅ Import repository ke Vercel
2. ✅ Konfigurasi build settings
3. ✅ Setup environment variables
4. ✅ Tambah custom domain
5. ✅ Deploy production
6. ✅ Test semua functionality
7. ✅ Monitor performance

**Result:** Website profesional dengan domain sendiri! 🚀