import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'

export async function POST() {
  try {
    // Sample cars data
    const sampleCars = [
      {
        name: 'Toyota Avanza',
        brand: 'Toyota',
        model: 'Avanza',
        year: 2023,
        price: 350000,
        description: 'Mobil keluarga yang nyaman dan irit bahan bakar',
        transmission: 'MANUAL',
        fuelType: 'GASOLINE',
        seats: 7,
        available: true
      },
      {
        name: 'Honda CR-V',
        brand: 'Honda',
        model: 'CR-V',
        year: 2023,
        price: 550000,
        description: 'SUV premium dengan fitur keselamatan lengkap',
        transmission: 'AUTOMATIC',
        fuelType: 'GASOLINE',
        seats: 5,
        available: true
      },
      {
        name: 'Suzuki Ertiga',
        brand: 'Suzuki',
        model: 'Ertiga',
        year: 2023,
        price: 300000,
        description: 'Mobil MPV yang luas dan hemat',
        transmission: 'MANUAL',
        fuelType: 'GASOLINE',
        seats: 7,
        available: true
      },
      {
        name: 'Mitsubishi Pajero Sport',
        brand: 'Mitsubishi',
        model: 'Pajero Sport',
        year: 2023,
        price: 750000,
        description: 'SUV tangguh untuk petualangan',
        transmission: 'AUTOMATIC',
        fuelType: 'DIESEL',
        seats: 7,
        available: true
      },
      {
        name: 'Toyota Camry',
        brand: 'Toyota',
        model: 'Camry',
        year: 2023,
        price: 800000,
        description: 'Sedan mewah dengan kenyamanan premium',
        transmission: 'AUTOMATIC',
        fuelType: 'GASOLINE',
        seats: 5,
        available: true
      },
      {
        name: 'Honda Brio',
        brand: 'Honda',
        model: 'Brio',
        year: 2023,
        price: 250000,
        description: 'Hatchback kompak yang lincah di perkotaan',
        transmission: 'MANUAL',
        fuelType: 'GASOLINE',
        seats: 5,
        available: true
      }
    ]

    // Insert sample cars
    for (const carData of sampleCars) {
      await db.car.create({
        data: carData
      })
    }

    // Create default settings
    await db.websiteSettings.upsert({
      where: { id: 'default' },
      update: {},
      create: {
        companyName: 'Rental Mobil Professional',
        phone: '+62 812-3456-7890',
        email: 'info@rentalmobil.com',
        address: 'Jakarta, Indonesia',
        about: 'Kami adalah perusahaan rental mobil terkemuka yang telah berpengalaman selama bertahun-tahun dalam menyediakan layanan transportasi terbaik untuk berbagai kebutuhan Anda. Dengan komitmen untuk memberikan pelayanan prima dan armada berkualitas, kami menjadi pilihan utama untuk kebutuhan rental mobil di Indonesia.',
        facebook: 'https://facebook.com/rentalmobil',
        instagram: 'https://instagram.com/rentalmobil',
        twitter: 'https://twitter.com/rentalmobil'
      }
    })

    return NextResponse.json({
      success: true,
      message: 'Sample data created successfully'
    })
  } catch (error) {
    console.error('Seed data error:', error)
    return NextResponse.json(
      { success: false, error: 'Internal server error' },
      { status: 500 }
    )
  }
}