import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'

export async function GET() {
  try {
    let settings = await db.websiteSettings.findFirst()
    
    if (!settings) {
      settings = await db.websiteSettings.create({
        data: {}
      })
    }

    return NextResponse.json({
      success: true,
      data: settings
    })
  } catch (error) {
    console.error('Settings API error:', error)
    return NextResponse.json(
      { success: false, error: 'Internal server error' },
      { status: 500 }
    )
  }
}

export async function PUT(request: NextRequest) {
  try {
    const body = await request.json()
    const {
      companyName,
      logo,
      phone,
      email,
      address,
      about,
      facebook,
      instagram,
      twitter
    } = body

    let settings = await db.websiteSettings.findFirst()
    
    if (!settings) {
      settings = await db.websiteSettings.create({
        data: {
          companyName,
          logo,
          phone,
          email,
          address,
          about,
          facebook,
          instagram,
          twitter
        }
      })
    } else {
      settings = await db.websiteSettings.update({
        where: { id: settings.id },
        data: {
          companyName,
          logo,
          phone,
          email,
          address,
          about,
          facebook,
          instagram,
          twitter
        }
      })
    }

    return NextResponse.json({
      success: true,
      data: settings
    })
  } catch (error) {
    console.error('Update settings error:', error)
    return NextResponse.json(
      { success: false, error: 'Internal server error' },
      { status: 500 }
    )
  }
}