import { NextRequest, NextResponse } from 'next/server'
import ZAI from 'z-ai-web-dev-sdk'

export async function POST(request: NextRequest) {
  try {
    const { message } = await request.json()

    if (!message) {
      return NextResponse.json(
        { success: false, error: 'Message is required' },
        { status: 400 }
      )
    }

    const zai = await ZAI.create()

    const completion = await zai.chat.completions.create({
      messages: [
        {
          role: 'system',
          content: `Anda adalah asisten virtual untuk perusahaan rental mobil profesional. Berikan respons yang ramah, informatif, dan membantu pelanggan dengan:

1. Informasi tentang layanan rental mobil
2. Bantuan pemilihan mobil yang sesuai
3. Penjelasan proses pemesanan
4. Informasi harga dan paket
5. Jawaban pertanyaan umum tentang rental mobil

Selalu respons dalam bahasa Indonesia yang sopan dan profesional. Jika ada pertanyaan di luar konteks rental mobil, arahkan kembali ke topik rental mobil dengan cara yang ramah.

Beberapa informasi penting:
- Kami menyediakan berbagai jenis mobil (MPV, SUV, Sedan, Hatchback)
- Harga mulai dari Rp 250.000 - 800.000 per hari
- Tersedia transmisi manual dan automatic
- Layanan 24/7
- Proses pemesanan mudah online
- Mobil terawat dan bersih`
        },
        {
          role: 'user',
          content: message
        }
      ],
      temperature: 0.7,
      max_tokens: 300
    })

    const response = completion.choices[0]?.message?.content

    if (!response) {
      throw new Error('No response from AI')
    }

    return NextResponse.json({
      success: true,
      response: response.trim()
    })

  } catch (error) {
    console.error('Chat API error:', error)
    
    // Return fallback response if AI fails
    return NextResponse.json({
      success: true,
      response: 'Maaf, saya sedang mengalami gangguan teknis. Silakan hubungi kami langsung melalui nomor telepon yang tersedia di halaman utama untuk bantuan lebih lanjut. Terima kasih atas pengertian Anda.'
    })
  }
}